VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "COutline"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private WithEvents o_FormOutLine As QuotMain
Attribute o_FormOutLine.VB_VarHelpID = -1

Public Event EvtActionAdd()
Public Event EvtActionOptionalAdd(ByVal li_OptionNumber As Integer)
Public Event EvtActionNodeClick()
Public Event EvtActionLeafClick(ByVal ls_OutLineCode As String, ByVal ls_OutlineDesc As String)
Public Event EvtActionLooseSelection()
Public Event EvtActionChangeView(ByVal li_NewView As Integer)
Public Event EvtFormClose()
Public Event EvtSearch(ByRef ls_OutLineCode As String)

Public Property Let i_FormWidth(ByVal li_FormWidth As Integer)
' MUST BE SET
' Set the Width of the main form
    mi_FormWidth = li_FormWidth
End Property

Public Property Let i_FormHeight(ByVal li_FormHeight As Integer)
' MUST BE SET
' Set the Height of the main form
    mi_FormHeight = li_FormHeight
End Property

Public Property Let s_SystemName(ByVal ls_SystemName As String)
' MUST BE SET
' Give The Id of the system to use. It defines what it's  displayed in the outline.
    ms_SystemName = ls_SystemName
    'ls_req = "EXEC Search_" & ms_ParamSystem & "_lst '" & ls_OutlineCode & "', '" & ms_LanguageCode & "', '" & QuoteParam(prg.LoginName) & "'"
    'QuotMain.tv_Outline.s_SearchReq = "EXEC Search_" & ls_SystemName & "_lst $1$, '$2$', '$3$'"
End Property

Public Property Let i_DefaultView(ByVal li_DefaultView As Integer)
' MUST BE SET
' Set the default view to display when a leaf is selected (it's for managing the view bar)
    mi_DefaultView = li_DefaultView
End Property

Public Property Let b_AddbuttonVisible(ByVal lb_State As Boolean)
' Define if the add button must be visible when no leaf is selected
' By default The add button is not visible
    gb_AddButtonVisible = lb_State
    If gb_FormLoaded Then
        QuotMain.pic_add.Visible = lb_State
    End If
End Property

Public Property Get b_AddbuttonVisible() As Boolean
' return if the add button must be visible when no leaf is selected
    b_AddbuttonVisible = gb_AddButtonVisible
End Property

Public Property Get l_FormHandle() As Long
' get the handle of the main screen in order to change the parent of the child maintenance screen
'Fix the problem when minimize window and when user change application
    l_FormHandle = QuotMain.hwnd
End Property

Public Property Get i_DefaultView() As Integer
' return the number of the default view
    i_DefaultView = mi_DefaultView
End Property

Public Property Let i_NbScreenView(ByVal li_NbScreenView As Integer)
'MUST BE SET
' Set the number of views (define the number of buttons in the view bar)
    mi_NbScreenView = li_NbScreenView
End Property

Public Property Get l_TopView() As Long
' Return the Top information where maintenance screen must be displayed
    l_TopView = ml_TopView
End Property

Public Property Get l_LeftView() As Long
' Return the Left information where maintenance screen must be displayed
    l_LeftView = ml_LeftView
End Property

Public Property Let l_TopToolsBar(ByVal ll_TopToolsbar As Long)
' MUST BE SET IF THERE IS A TOOLSBAR
' SET the top information of the toolsbar
    ml_TopToolsbar = 600 + ll_TopToolsbar
End Property

Public Property Let l_LeftToolsBar(ByVal ll_LeftToolsbar As Long)
' MUST BE SET IF THERE IS A TOOLSBAR
' SET the left information of the toolsbar
    ml_LeftToolsbar = 3075 + ll_LeftToolsbar
End Property


Public Sub show()
' Show the outline window. Be careful, all properties must be set before.
    QuotMain.show
End Sub

'Public Sub RefreshOutline()
' Clear the tree then and reload the outline to show the actual selected element in the tree.
    'QuotMain.ReFillTestOutline
'End Sub

Public Sub SearchOutline(ByVal ls_OutLineCode As String)
' Open the item given by it's ID the closest from the element actually selected in the tree.
    QuotMain.FSearchOutline ls_OutLineCode
End Sub

Public Sub LocalAddItem(ByVal ls_OutLineCode As String, ByVal ls_OutlineDesc As String)
' From a given item code and description, add the item in all branches already opened.
' The function ask the server where the code must be visible (it return all paths)
' then the sub add the element in all path already opened
' so it's minimize the communication with the SQL base because we don't clear
' the tree and reload all branch
'
    QuotMain.FLocalAddItem ls_OutLineCode, ls_OutlineDesc
End Sub

Public Sub LocalDelItem(ByVal ls_OutLineCode As String)
' From a given item code, delete it in all branches already opened.
' we don't communicate with the SQL Base
    QuotMain.FLocalDelItem ls_OutLineCode
End Sub

Public Sub ChangeView(ByVal li_View As Integer)
' Change the tabs appearance to show that it's now the tab number li_View that is shown on the screen.
' We don't Fire an changeView event
Dim li_Count As Integer
    ' de-select the old view and select the good one
    For li_Count = 1 To li_View - 1
        QuotMain.cmd_View(li_Count).Font.Bold = False
    Next li_Count
    QuotMain.cmd_View(li_View).Font.Bold = True
    For li_Count = li_View + 1 To mi_NbScreenView
        QuotMain.cmd_View(li_Count).Font.Bold = False
    Next li_Count
End Sub



Public Function SetParent(ByVal l_HwndParent As Long) As Long
'Must be call to link the outline window with it's calling window
'Fix the problem when minimize window and when user change application
    gl_OldquotationoutlineHwnd = SetOwner(QuotMain.hwnd, l_HwndParent)
    SetParent = gl_OldquotationoutlineHwnd
End Function


Public Sub HideViewBar()
'Hide the view bar (bar at the top left of the screen, used to change the detail window)
'Must be call when a view is closed
    QuotMain.SSP_Tab.Visible = KO
End Sub

'----------------------------------------------------------------------------------------
'----------------------------------------------------------------------------------------
' Private Part
'----------------------------------------------------------------------------------------
'----------------------------------------------------------------------------------------
Private Sub Class_Initialize()
    gb_FormLoaded = KO
    gb_AddButtonVisible = KO
    Set o_FormOutLine = QuotMain
    gb_MultipleChoiceWhenAdd = KO
End Sub

Private Sub Class_Terminate()
    Set o_FormOutLine = Nothing
End Sub

Private Sub o_FormOutLine_FormEvtActionChangeView(ByVal li_NewView As Integer)
    MouseOff
    RaiseEvent EvtActionChangeView(li_NewView)
    MouseOn
End Sub

Private Sub o_FormOutLine_FormEvtActionClose()
    MouseOff
    RaiseEvent EvtFormClose
    MouseOn
End Sub

Private Sub o_FormOutLine_FormEvtActionLeafClick(ByVal gs_OutlineCode As String, ByVal gs_OutlineDesc As String)
    MouseOff
    RaiseEvent EvtActionLeafClick(gs_OutlineCode, gs_OutlineDesc)
    MouseOn
End Sub

Private Sub o_FormOutLine_FormEvtActionAdd()
    MouseOff
    RaiseEvent EvtActionAdd
    MouseOn
End Sub


Private Sub o_FormOutLine_FormEvtActionLooseSelection()
    MouseOff
    RaiseEvent EvtActionLooseSelection
    MouseOn
End Sub

Private Sub o_FormOutLine_FormEvtActionNodeClick(ByVal ls_OutLineCode As String, ByVal ls_OutlineDesc As String)
    MouseOff
    RaiseEvent EvtActionNodeClick
    MouseOn
End Sub

Private Sub o_FormOutLine_FormEvtActionOptionalAdd(ByVal li_OptionNumber As Integer)
    RaiseEvent EvtActionOptionalAdd(li_OptionNumber)
End Sub

Private Sub o_FormOutLine_FormEvtSearch()
Dim ls_OutLineCode As String
    RaiseEvent EvtSearch(ls_OutLineCode)
    If ls_OutLineCode <> "" Then
        SearchOutline (ls_OutLineCode)
    End If
End Sub

